<?php

namespace App\Http\Controllers;

use App\Http\Requests\AuthRequest;
use App\Http\Requests\VerifysmsRequest;
use App\Services\AuthService;
use Illuminate\Http\JsonResponse;

class AuthController extends Controller
{

    public function __construct(
        protected AuthService $authService,

    ) {}
    public function sendCode(AuthRequest $request): JsonResponse
    {
        $data = $this->authService->registerOrLogin($request);
        return response()->json($data);
    }
    public function verifysms(VerifysmsRequest $request): JsonResponse
    {
        return response()->json($this->authService->verifysms($request));
    }
    public function logout():JsonResponse
    {
        $response = $this->authService->logout();
        return response()->json($response);
    }

}
