<?php

namespace App\Http\Controllers;

use App\Http\Requests\Cities\UpdateCheckedRequest;
use App\Services\CityService;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class CityController extends Controller
{
    public function __construct(
        protected CityService $city_service
    ) {}

    public function getCities(Request $request): JsonResponse
    {
        $firmId = $request->header('firm_id');
        $cities=$this->city_service->getCities($firmId);
        return response()->json($cities);
    }
        public function citiesByChecked(Request $request):JsonResponse
    {
        $cities=$this->city_service->citiesByChecked($request);
        return response()->json($cities);
    }
    public function updateChecked(UpdateCheckedRequest $request):JsonResponse
    {
        return response()->json($this->city_service->updateChecked($request));
    }
}

