<?php

namespace App\Http\Controllers;

use App\Models\Firm;
use App\Services\Notifications\NotificationService;

class DashboardController extends Controller
{
    public function __construct(
        protected NotificationService $notificationService
    )
    {
    }

    /**
     * @OA\Get(
     *      path="/api/dashboard/{firmId}",
     *      tags={"Dashboard"},
     *      security={{"bearerAuth":{}}},
     *      summary="Get main dashboard data",
     *      description="Get balance, recommendations, and notification status",
     *      @OA\Parameter(
     *          name="firmId",
     *          in="path",
     *          required=true,
     *          @OA\Schema(type="integer")
     *      ),
     *      @OA\Response(
     *          response=200,
     *          description="Successful operation",
     *          @OA\JsonContent(
     *              type="object",
     *              @OA\Property(
     *                  property="balance",
     *                  type="object",
     *                  @OA\Property(property="amount", type="number", format="double"),
     *                  @OA\Property(property="currency", type="string")
     *              ),
     *              @OA\Property(
     *                  property="recommendations",
     *                  type="array",
     *                  @OA\Items(
     *                      type="object",
     *                      @OA\Property(property="id", type="string"),
     *                      @OA\Property(property="title", type="string"),
     *                      @OA\Property(property="description", type="string"),
     *                      @OA\Property(property="actionLabel", type="string", nullable=true)
     *                  )
     *              ),
     *              @OA\Property(property="hasUnreadNotifications", type="boolean")
     *          )
     *      )
     * )
     */
    public function dashboard($firmId)
    {
        $firm = Firm::findOrFail($firmId);

        // Check if user has access to this firm (optional, but recommended)
        // For now, we assume if they are authenticated and request it, we show it,
        // or we could check UserFirm table.
        // $user = Auth::user();
        // if (!$user->firms()->where('firms.id', $firmId)->exists()) {
        //    return response()->json(['message' => 'Unauthorized'], 403);
        // }

        $balance = [
            'amount' => (double)($firm->left_days ?? 0),
        ];

        $recommendations = []; // Placeholder for now

        $notifications = $this->notificationService->get();
        $hasUnreadNotifications = !$notifications->isEmpty();

        return response()->json([
            'balance' => $balance,
            'recommendations' => $recommendations,
            'has_unread_notifications' => $hasUnreadNotifications,
            'company_logo' => $firm->img
        ]);
    }
}
