<?php

namespace App\Http\Controllers;

use App\Http\Requests\GetProductByIdRequest;
use App\Services\Drugstore\DrugstoreService;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class DrugstoreController extends Controller
{
    public function __construct(
        protected DrugstoreService $drugstoreService
    ){}

    public function getProductById(GetProductByIdRequest $request):JsonResponse
    {
        return response()->json($this->drugstoreService->getProductById($request));
    }

}
