<?php

namespace App\Http\Controllers;

use App\Http\Requests\Firms\CreateFirmRequest;
use App\Http\Requests\Firms\UpdateFirmRequest;
use App\Http\Requests\Firms\UpdateGeoRequest;
use App\Services\Day_plusService;
use App\Services\FirmService;
use Illuminate\Http\Request;

class FirmController extends Controller
{
    public function __construct(
        protected FirmService $firmService,
        protected Day_plusService $day_plus_service,
    ) {}
    public function createFirm(CreateFirmRequest $create_firm_request) {
        $firm = $this->firmService->createFirm($create_firm_request);
        return response()->json($firm);
    }
    public  function getMyFirms()
    {
        $firm = $this->firmService->myFirms();
        return response()->json($firm);
    }
    public function firmCategories()
    {
        $categoriesFirm=$this->firmService->categoriesFirm();

        return response()->json($categoriesFirm,);
    }

    public function day_plus(Request $request)
    {
        $day_plus=$this->day_plus_service->day_plus($request);

        return response()->json($day_plus);
    }
    public  function  firmProfile(Request $request)
    {
        $firmProfile=$this->firmService->firmProfile($request);

        return response()->json($firmProfile);
    }
    public function workingData(Request $request)
    {
        $workingData=$this->firmService->workingData($request);

        return response()->json($workingData);

    }
    public function updateWorkingData(UpdateFirmRequest $request)
    {
        $workingData=$this->firmService->updateWorkingData($request);
        return response()->json($workingData);
    }

    public function updateGeo(UpdateGeoRequest $request)
    {
        $updated = $this->firmService->updateGeo($request);
        return response()->json($updated);
    }
}

