<?php

namespace App\Http\Controllers;

use App\Http\Requests\RequestCallRequest;
use App\Services\HelpDeskService;
use Illuminate\Http\JsonResponse;

class HomeController extends Controller
{
    public function __construct(
        protected HelpDeskService $help_desk_service
    ) {}
    /**
     * @OA\Get(
     *      path="/api/help_desk",
     *      tags={"Home"},
     *       security={{"bearerAuth":{}}},
     *      summary="Служба поддержки",
     *      description="Служба поддержки",
     *      @OA\Response(
     *          response=200,
     *          description="Successful operation",
     *          @OA\MediaType(
     *           mediaType="application/json",
     *      )
     *      ),
     *  )
     */
    public function HelpDesk(): JsonResponse
    {
        $helpDesk = $this->help_desk_service->HelpDesk();
        return response()->json($helpDesk);
    }
    /**
     * @OA\Post(
     *     path="/api/request_call",
     *     tags={"Home"},
     *     security={{"bearerAuth":{}}},
     *     @OA\RequestBody(
     *         required=true,
     *     @OA\MediaType(
     *              mediaType="application/json",
     *             @OA\Schema(
     *                @OA\Property(
     *                      property="phone",
     *                      type="string",
     *                      example="+992927952668"
     *                  )
     *             )
     *         )
     *     ),
     *     @OA\Response(
     *         response=200,
     *         description="Success",
     *         @OA\MediaType(
     *           mediaType="application/json",
     *      )
     *     ),
     *     @OA\Response(
     *         response=401,
     *         description="Unauthenticated",
     *         @OA\JsonContent(
     *             type="object",
     *             @OA\Property(property="message", type="string", example="Unauthenticated")
     *         )
     *     )
     * )
     */
    public function Requestcall(RequestCallRequest $request): JsonResponse
    {
        return response()->json($this->help_desk_service->Requestcall($request->phone));
    }
}
