<?php

namespace App\Http\Controllers\Nomenclatures;

use App\Http\Controllers\Controller;
use App\Http\Requests\Nomenclatures\GetAnalogueByIdRequest;
use App\Http\Requests\Nomenclatures\GetBySearchRequest;
use App\Http\Requests\Nomenclatures\GetDetailsByIdRequest;
use App\Services\Nomenclatures\NomenclatureService;
use Illuminate\Http\JsonResponse;

class NomenclatureController extends Controller
{
    public function __construct
    (
        protected NomenclatureService $nomenclatureService
    )
    {
    }

    public function get_nomenclatures_by_search(GetBySearchRequest $request): JsonResponse
    {
        $search_query = $request->input( 'search_query') ?? '';
        $product_type_id = $request->input('product_type_id');
        return response()->json($this->nomenclatureService->get_nomenclatures_by_search($search_query, $product_type_id));
    }

    public function get_details_by_id(GetDetailsByIdRequest $request): JsonResponse
    {
        $nomenclature_id = $request->input( 'nomenclature_id');

        return response()->json($this->nomenclatureService->get_details_by_id($nomenclature_id));
    }

    public function get_analogues(GetAnalogueByIdRequest $request): JsonResponse
    {
        $nomenclature_id = $request->input( 'nomenclature_id');

        return response()->json($this->nomenclatureService->get_analogues($nomenclature_id));
    }
}
