<?php

namespace App\Http\Controllers;

use App\Http\Requests\Order\CreareOrderRequest;
use App\Http\Requests\Order\DeleteOrderRequest;
use App\Http\Requests\Order\deleteProductForOrderItemRequest;
use App\Http\Requests\Order\GetOrderRequest;
use App\Http\Requests\Order\GetProductByOderItemIdRequest;
use App\Http\Requests\Order\SendOrderRequest;
use App\Http\Requests\Order\UpdateQuantityRequest;
use App\Services\OrderServices\OrderService;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    public function __construct(
        protected OrderService $orderService
    ){}
    public function addToOrder(CreareOrderRequest $request)
    {
        $order = $this->orderService->addToOrder($request);
        return response()->json($order);
    }
    public function orders(GetOrderRequest $request)
    {
        $orders = $this->orderService->orders($request);
        return response()->json($orders);
    }
    public function SendOrder(SendOrderRequest $request)
    {
        $SendOrder = $this->orderService->SendOrder($request);
        return response()->json($SendOrder);
    }

    public function deleteOrder(DeleteOrderRequest $request)
    {
        $deleteOrder = $this->orderService->deleteOrder($request);
        return response()->json($deleteOrder);
    }
    public function deleteProductForOrderItem(deleteProductForOrderItemRequest $request)
    {
        $deleteProductForOrderItem = $this->orderService->deleteProductForOrderItem($request);
        return response()->json($deleteProductForOrderItem);
    }
    public function updateQuantity(UpdateQuantityRequest $request)
    {
        $saveOrderAllHistory = $this->orderService->updateQuantity($request);
        return response()->json($saveOrderAllHistory);
    }
    public function getStatusOrder()
    {
        return response()->json($this->orderService->getStatus());
    }
    public function getOrderItems(Request $request)
    {
        return response()->json($this->orderService->getOrderItemsByOrderId($request));
    }
    public function getProductByOderItemId(GetProductByOderItemIdRequest $request)
    {
        return response()->json($this->orderService->getProductByOderItemId($request));
    }
}
