<?php

namespace App\Http\Controllers;


use App\Http\Requests\Partners\PartnerIdRequest;
use App\Http\Requests\Partners\PartnerRequest;
use App\Http\Requests\PartnerStatisticRequest;
use App\Services\PartnerService;
use App\Services\Reviews\ReviewStatisticsService;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;


class PartnersController extends Controller
{
    public function __construct(
        protected PartnerService          $partner_service,
        protected ReviewStatisticsService $reviewStatisticsService
    )
    {
    }

    public function myPartners(PartnerRequest $request): JsonResponse
    {
        $myPartners = $this->partner_service->partners($request);
        return response()->json($myPartners);
    }

    public function partnerInfo(PartnerIdRequest $request): JsonResponse
    {
        return response()->json($this->partner_service->partnerInfo($request));
    }

    public function getPartnerDetails(PartnerIdRequest $request): JsonResponse
    {
        $partnerInfo = $this->partner_service->partnerInfo($request);
        $reviewSummary = $this->reviewStatisticsService->getRatingSummary($request->partner_id);

        return response()->json([
            'partner' => $partnerInfo->first(),
            'review_summary' => $reviewSummary
        ]);
    }

    public function updateChecked(Request $request): JsonResponse
    {

        return response()->json($this->partner_service->updateChecked($request));

    }

    public function statistic(PartnerStatisticRequest $request): JsonResponse
    {
        return response()->json($this->partner_service->statistic($request->validated()));
    }

    public function countChecked(Request $request): JsonResponse
    {
        return response()->json($this->partner_service->countChecked($request));
    }
}
