<?php

namespace App\Http\Controllers;

use App\Http\Requests\CallbackPaymentRequest;
use App\Http\Requests\NewPaymentRequest;
use App\Services\Payments\PaymentService;
use Illuminate\Http\JsonResponse;

class PaymentController extends Controller
{
    public function __construct(
        protected PaymentService $payment_service
    )
    {
    }

    public function getAllPay()
    {
        $payments = $this->payment_service->getPayments();
        return response()->json($payments);
    }

    public function newPayments(NewPaymentRequest $request): JsonResponse
    {
        $firmId = $request->header('firm_id');
        $method_id = $request->method_id;

        return response()->json($this->payment_service->newPayments($firmId, $method_id));
    }

    public function callbackDc(CallbackPaymentRequest $request):JsonResponse
    {
        return response()->json($this->payment_service->callbackDc($request->validated()));

    }
}
