<?php

namespace App\Http\Controllers;

use App\Http\Requests\Review\ReviewCreateRequest;
use App\Services\Reviews\ReviewService;
use App\Services\Reviews\ReviewStatisticsService;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class ReviewController extends Controller
{
    public function __construct
    (
        protected  ReviewService $reviewService,
        protected ReviewStatisticsService $statisticsService
    ){}

    public function create(ReviewCreateRequest $request):JsonResponse
    {
        return response()->json($this->reviewService->create($request));
    }

    /**
     * @throws ContainerExceptionInterface
     * @throws NotFoundExceptionInterface
     */
    public function getReviews(Request $request):JsonResponse
    {
        $supplier_id = $request->supplier_id;
        $page = request()->get('page', 1);
        return response()->json($this->reviewService->getAllReviews( $supplier_id, $page));
    }
    public function reasonList():JsonResponse
    {
        return response()->json($this->reviewService->reasonList());
    }


}
