<?php

namespace App\Http\Controllers;

use App\Http\Requests\Searches\SearchRequest;
use App\Services\Search\ProductSearchService;
use App\Services\Search\ProductTypeService;
use App\Services\Search\SearchService;
use Illuminate\Http\Request;

class SearchController extends Controller
{
    public function __construct(
        protected ProductTypeService $productTypeService,
        protected SearchService      $searchService
    ) {}

    public function search(SearchRequest $request, ProductSearchService $service)
    {
        $firmId = $request->header('firm-id');
        return $service->search($request->toParams(), $firmId);
    }

    public function getProductType(Request $request)
    {
        $productType = $this->productTypeService->getProductType($request);
        return response()->json($productType);
    }
}
