<?php

namespace App\Http\Controllers;

use App\Http\Requests\User\GetFirmRequest;
use App\Http\Requests\User\UserProfileRequest;
use App\Services\UserService;

class UserController extends Controller
{
    public function __construct(
        protected UserService $user_service
    ) {}
    public function getMyFirms()
    {
        $myfirms = $this->user_service->myFirms();
        return response()->json($myfirms);
    }

    public function profile(UserProfileRequest $request){
        $profile= $this->user_service->profile($request);
        return response()->json([
            'message'=>"success"
        ],200);
    }
}
