<?php

namespace App\Http\Middleware;

use App\Models\Firm;
use App\Models\Firmlog;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Symfony\Component\HttpFoundation\Response;

class left_daysMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response) $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $firmId = $request->header('firm_id');
        $validator = \Illuminate\Support\Facades\Validator::make(
            ['firm_id' => $firmId],
            ['firm_id' => 'required|integer|min:1|exists:firms,id']
        );
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }
        $firmId = (int)$firmId;
        $userId = Auth::id();
        $today = now()->format('Y-m-d');

        $firm = Firm::whereHas('userFirms', function ($query) use ($userId) {
            $query->where('user_id', $userId)
                ->whereIn('status', [1, 2]);
        })
            ->where('id', $firmId)
            ->first();
        if (!$firm) {
            return response()->json([
                'message' => 'Фирма не найдена',
            ], 403);
        }
        if ($firm->left_days <= 0 and $firm->date_sign < $today) {
            return response()->json([
                'message' => 'Ваш баланс исчерпан. Для продолжения работы пополните счёт. У нас есть пошаговая инструкция со скриншотами — воспользуйтесь ею, если что-то непонятно запросите звонок или напишите нам удобным вам способом.',
            ], 402);
        }
        $firmlog = Firmlog::where('user_id', $userId)
            ->where('firm_id', $firmId)
            ->where('date', $today)
            ->first();
        if ($firmlog) {
            $now = now();
            $last = \Carbon\Carbon::parse($firmlog->last_activity_time);
            $duration = $now->diffInSeconds($last);

            if ($duration >= 10 && $duration <= 1800) {
                $firmlog->session_duration += $duration;
                $firmlog->last_activity_time = $now;
                $firmlog->save();
            }
            return $next($request);
        }
        $total = Firmlog::where('firm_id', $firmId)
            ->where('date', $today)
            ->count();

        $profit = Firmlog::Where("firm_id", $firmId)->where('profit', 1)->where('date', $today)->count();
        $tarif = 0;
        $tarif += $profit;
        if ($total > $tarif) {
            return response()->json([
                "message" => "Вы превысили максимальное количество использользованных устройств."
            ], 403);
        }
        if (!$firmlog) {
            $data = [
                'user_id' => $userId,
                'firm_id' => $firmId,
                'session_id' => $request->header('User-Agent'),
                'date' => $today,
                'day_plus' => 0,
                'last_activity_time' => now()
            ];
            if ($today > $firm->date_sign) {
                $data['profit'] = 1;
                $firm->decrement('left_days');
                $firm->update(['date_sign' => $today]);

                $firm_id = $firm->id;
                $today_key = "cache_cleared_{$firm_id}_" . date('Y-m-d');
                if (!Cache::has($today_key)) {
                    Cache::forget("discounts_to_{$firm_id}");
                    Cache::forget("firm_overheads_{$firm_id}");
                    Cache::put($today_key, true, now()->addDay());
                }
            }
            Firmlog::create($data);
            $firm = Firm::where('id', $firmId)->first();
            activity('auth_firm')
                ->performedOn($firm)
                ->withProperties([
                    'title' => "Вход выполнен!",
                    "body" => "Вход выполнен, снято 1 день. Осталось: " . $firm->left_days,
                ])
                ->log("Вход выполнен");
        }
        return $next($request);
    }
}
