<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class CallbackPaymentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }


    public function rules(): array
    {
        return [
            'merchant' => 'string|required',
            'order_id' => 'string|required',
            "invoice_id" => "string|required",
            "amount" => "required",
            "currency" => "string|required",
            "payer" => "string|required",
            "payid" => "string|required",
            "pay_date" => "date|required"
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(
            response()->json([
                'status'=>false,
                'message'=>'Validation Error',
                'Error'=>$validator->errors()
            ])
        );
    }
}
