<?php

namespace App\Http\Requests\Firms;

use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class UpdateFirmRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'photo'=>'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:5120',
            'phone'=>'required|digits:9',
            'additional_phone'=>'nullable|digits:9',
            'country_code'=>'required|exists:countries,country_code',
            'additional_country_code'=>'nullable|exists:countries,country_code|required_with:additional_phone',
            'address'=>'nullable|string|min:5|max:255'
        ];
    }
    public  function failedValidation(Validator $validator)
    {
        throw  new  HttpResponseException(
          response()->json([
              'success'=>false,
              'message'=>'Validate Error',
              'Error'=>$validator->errors()
          ],422),
        );
    }
}
