<?php

namespace App\Http\Requests;

use App\Rules\ValidateFirmGroup;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class GetProductByIdRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }


    public function rules(): array
    {
        $firmId = $this->header('firm-id');
        return [
            "id" => "required|exists:drugstores,id",
            "supplier_id" => [
                'required',
                new ValidateFirmGroup($firmId),
            ]
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new  HttpResponseException(response()->json([
            'status' => false,
            'message' => 'Validation Error',
            'Error' => $validator->errors()
        ], 422)
        );
    }
}
