<?php

namespace App\Http\Requests\Nomenclatures;

use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class GetAnalogueByIdRequest extends FormRequest
{
    public mixed $nomenclature_id;

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'nomenclature_id' => 'required|exists:product_names,id',
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw  new HttpResponseException(
            response()->json([
                'status' => false,
                'message' => 'Validation Error',
                'Error' => $validator->errors()
            ], 422)
        );
    }
}
