<?php

namespace App\Http\Requests\Nomenclatures;

use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class GetBySearchRequest extends FormRequest
{
    public mixed $search_query;
    public mixed $product_type_id;

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }


    public function rules(): array
    {
        return [
            'search_query' => 'nullable|string',
            'product_type_id' => 'required|exists:product_name_types,id'
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new  HttpResponseException(
            response()->json([
                'success' => false,
                'message' => 'Validation Error',
                'Error' => $validator->errors()
            ], 422),
        );
    }
}
