<?php

namespace App\Http\Requests\Order;

use App\Rules\ValidateFirmGroup;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class GetOrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }


    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $myFirmId = $this->header('firm-id');
        return [
            "date_start"=>"nullable|date_format:Y-m-d",
            "date_end"=>"nullable|date_format:Y-m-d",
            "status"=>"nullable|integer",
            "partner_id"=>[
                'nullable',
                new ValidateFirmGroup($myFirmId),
            ]
        ];
    }


    public function failedValidation(Validator $validator)
    {
       throw  new  HttpResponseException(response()->json([
           'success' => false,
           'message' => 'Validate Error',
           'Error' => $validator->errors()
       ],422));
    }
}
