<?php

namespace App\Http\Requests\Order;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class UpdateQuantityRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'id'=>'required|exists:orderlists,id',
            'quantity'=>'required|integer|min:0'
        ];
    }
    public function failedValidation(Validator $validator){
        throw new   HttpResponseException(
            response()->json([
                'success'=>false,
                'message'=>'Validation Error',
                'Error'=>$validator->errors()
            ],422)
        );
    }
}
