<?php

namespace App\Http\Requests;

use App\Rules\ValidateFirmGroup;
use Illuminate\Foundation\Http\FormRequest;

class PartnerStatisticRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $firmId = $this->header('firm_id');
        return [
            'date_start' => ['nullable', 'date'],
            'date_end' => ['nullable', 'date'],
            'supplier_id' => ['required',
                new ValidateFirmGroup($firmId),
            ]
        ];
    }
}
