<?php

namespace App\Http\Requests\Review;

use App\Rules\ValidateFirmGroup;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class ReviewCreateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $myFirmId = $this->header('firm-id');
        return [
            'supplier_id'=>['required',
                new ValidateFirmGroup($myFirmId)],
            'product_id'=>'required|exists:drugstores,id',
            'reason_list_id'=>'required|exists:reason_lists,id',
            'comment'=>'nullable|string'
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new  HttpResponseException(response()->json([
            'success'=>false,
            'message' => 'Validate Error',
            'Error' => $validator->errors()
        ],422));
    }
}
