<?php

namespace App\Http\Requests\Review;

use App\Rules\ValidateFirmGroup;
use Illuminate\Foundation\Http\FormRequest;

class getReviewsByIdRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $myFirmId=$this->header('firm-id');
        return [
            'supplier_id' => ['required',
                new ValidateFirmGroup($myFirmId)
            ]
        ];
    }
}
