<?php

namespace App\Interfaces\OrderInterfaces;

interface OrderInterface
{
    public function order($firmId, array $partnerId , ?string $search=null, ?string $dateStart= null, ?string $dateEnd= null,?int $status=null);
    public function addToOrder($data);
    public function addToOrderItem($data);
    public function getOrder($income_firm_id, $sender_firm_id);
    public function getOrderList($order_id, $product_id, $price, $discount);
    public function getOrderByOrderId($order_id,$firmId,$nowStatus);

    public function updateStatus($firm_id, $order_id, $comment, $nowStatus, $newStatus);
    public function deleteOrder($firmId,$orders_id);
    public function getProductByItemId($orderList_id,$firmId);
    public function deleteProductForOrderItem($orderList_id,$firmId);
    public function updateQuantity($orderList_id, $firmId, $quantity);
    public function getOrderItemByOrderId($firmId,$orderId);
    public function getProductByOderItemId($firmId,$oderItemId);
    public function getProductQuantityById(int $product_id, int $supplier_id);
}
