<?php

namespace App\Interfaces;

use App\Models\Plan;

interface PaymentRepositoryInterface
{
    public function getPayments();

    public function getPaymentId(int $firmId);

    public function getFirmPlan($firmId);

    public function create($firm_plan_id, $amount);

    public function createTransaction($result, int $payment_id, int $method_id);

    public function GetTransactionByPaymentId(int $payment_id);

    public function updateTransactionById(int $id, array $date): string;

    public function getPlanTypeByPaymentId($payment_id): ?Plan;

    public function getPaymentById($payment_id);

    public function getFirmIdByFirmPlanId($firmPlanId);

    public function getAmountTotalByPaymentId($payment_id);

    public function updateFirmLeftDaysByFirmId(int $firmId, int $amount): void;

    public function updateFirmPlanByFirmId(int $firmId, array $data): void;

    public function updatePaymentStatusById($paymentId): void;

}

