<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Carbon;

/**
 * @property int $id
 * @property int $overhead_id
 * @property string|null $title
 * @property int|null $quantity
 * @property string|null $price
 * @property string|null $discount
 * @property string|null $date_expire
 * @property string|null $manufacture
 * @property string|null $barcode
 * @property int|null $access_id
 * @property int|null $status
 * @property int $drug_parsed_to this is for parsing to firm_product. project ImportFromDrugstoreToFirmProduct dev.icorp.tech
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read Overhead|null $overhead
 * @method static Builder<static>|Drugstore newModelQuery()
 * @method static Builder<static>|Drugstore newQuery()
 * @method static Builder<static>|Drugstore query()
 * @method static Builder<static>|Drugstore whereAccessId($value)
 * @method static Builder<static>|Drugstore whereBarcode($value)
 * @method static Builder<static>|Drugstore whereCreatedAt($value)
 * @method static Builder<static>|Drugstore whereDateExpire($value)
 * @method static Builder<static>|Drugstore whereDiscount($value)
 * @method static Builder<static>|Drugstore whereDrugParsedTo($value)
 * @method static Builder<static>|Drugstore whereId($value)
 * @method static Builder<static>|Drugstore whereManufacture($value)
 * @method static Builder<static>|Drugstore whereOverheadId($value)
 * @method static Builder<static>|Drugstore wherePrice($value)
 * @method static Builder<static>|Drugstore whereQuantity($value)
 * @method static Builder<static>|Drugstore whereStatus($value)
 * @method static Builder<static>|Drugstore whereTitle($value)
 * @method static Builder<static>|Drugstore whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class Drugstore extends Model
{
    public function overhead() :BelongsTo
    {
        return $this->belongsTo(Overhead::class);
    }
    public function review():HasMany
    {
        return $this->hasMany(Review::class);
    }


}
