<?php

namespace App\Models;

use App\Services\Plans\PlanService;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Carbon;

/**
 * @property int $id
 * @property string|null $code
 * @property string|null $title
 * @property int|null $id_city
 * @property int|null $id_category
 * @property string $address
 * @property string|null $firm_address
 * @property string|null $phone
 * @property string|null $phone1
 * @property string|null $email
 * @property string|null $email1
 * @property int|null $guest
 * @property string|null $inn
 * @property int $agree
 * @property string|null $img
 * @property string|null $getcode
 * @property string|null $date_sign
 * @property int|null $left_days
 * @property string|null $start_free_hour
 * @property int|null $earned
 * @property int|null $promote_id
 * @property int|null $status
 * @property int|null $ident
 * @property int $stock
 * @property int|null $default_city_id
 * @property int|null $organization_id
 * @property int|null $firm_name_number
 * @property string|null $doc_1
 * @property string|null $doc_2
 * @property string|null $latitude
 * @property string|null $longtitude
 * @property string|null $delivery_terms
 * @property string|null $delivery_times
 * @property int|null $online_order
 * @property int|null $show_manufacture
 * @property int|null $show_date_expire
 * @property int $shift_count
 * @property int $dushanbe_investor если 1 тогда получаетя что был подключен через Иброхимбек и Абдухафиз
 * @property int $opt_for_all если 1 тогда для всех будет доступен прайс данной компании
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read Category|null $category
 * @property-read Collection<int, Overhead> $overhead
 * @property-read int|null $overhead_count
 * @property-read Collection<int, UserFirm> $userFirms
 * @property-read int|null $user_firms_count
 * @method static Builder<static>|Firm newModelQuery()
 * @method static Builder<static>|Firm newQuery()
 * @method static Builder<static>|Firm query()
 * @method static Builder<static>|Firm whereAddress($value)
 * @method static Builder<static>|Firm whereAgree($value)
 * @method static Builder<static>|Firm whereCode($value)
 * @method static Builder<static>|Firm whereCreatedAt($value)
 * @method static Builder<static>|Firm whereDateSign($value)
 * @method static Builder<static>|Firm whereDefaultCityId($value)
 * @method static Builder<static>|Firm whereDeliveryTerms($value)
 * @method static Builder<static>|Firm whereDeliveryTimes($value)
 * @method static Builder<static>|Firm whereDoc1($value)
 * @method static Builder<static>|Firm whereDoc2($value)
 * @method static Builder<static>|Firm whereDushanbeInvestor($value)
 * @method static Builder<static>|Firm whereEarned($value)
 * @method static Builder<static>|Firm whereEmail($value)
 * @method static Builder<static>|Firm whereEmail1($value)
 * @method static Builder<static>|Firm whereFirmAddress($value)
 * @method static Builder<static>|Firm whereFirmNameNumber($value)
 * @method static Builder<static>|Firm whereGetcode($value)
 * @method static Builder<static>|Firm whereGuest($value)
 * @method static Builder<static>|Firm whereId($value)
 * @method static Builder<static>|Firm whereIdCategory($value)
 * @method static Builder<static>|Firm whereIdCity($value)
 * @method static Builder<static>|Firm whereIdent($value)
 * @method static Builder<static>|Firm whereImg($value)
 * @method static Builder<static>|Firm whereInn($value)
 * @method static Builder<static>|Firm whereLatitude($value)
 * @method static Builder<static>|Firm whereLeftDays($value)
 * @method static Builder<static>|Firm whereLongtitude($value)
 * @method static Builder<static>|Firm whereOnlineOrder($value)
 * @method static Builder<static>|Firm whereOptForAll($value)
 * @method static Builder<static>|Firm whereOrganizationId($value)
 * @method static Builder<static>|Firm wherePhone($value)
 * @method static Builder<static>|Firm wherePhone1($value)
 * @method static Builder<static>|Firm wherePromoteId($value)
 * @method static Builder<static>|Firm whereShiftCount($value)
 * @method static Builder<static>|Firm whereShowDateExpire($value)
 * @method static Builder<static>|Firm whereShowManufacture($value)
 * @method static Builder<static>|Firm whereStartFreeHour($value)
 * @method static Builder<static>|Firm whereStatus($value)
 * @method static Builder<static>|Firm whereStock($value)
 * @method static Builder<static>|Firm whereTitle($value)
 * @method static Builder<static>|Firm whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class Firm extends Model
{

    protected $fillable = [
        'title',
        'id_category',
        'id_city',
        'phone',
        'img',
        'address',
        'date_sign',
        'left_days',

    ];
    protected $table = 'firms';

    public function users():BelongsToMany
    {
       return $this->belongsToMany(User::class, 'userfirms');
    }
    public function partnergroups():BelongsToMany
    {
        return $this->belongsToMany(Firm::class,'partnergroups','firm2','firm1');
    }
    public function userFirms(): HasMany
    {
        return $this->hasMany(UserFirm::class, 'firm_id');
    }

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class, 'id_category');
    }

    public function overhead(): HasMany
    {
        return $this->hasMany(Overhead::class);
    }

    public function plans(): BelongsToMany
    {
        return $this->belongsToMany(PlanService::class, 'firmplans');
    }
    public function reviews():HasMany
    {
        return  $this->hasMany(Review::class);
    }
    public function orders():HasMany
    {
        return $this->hasMany(Order::class,'id_firm_income');
    }

}
