<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;


/**
 * @property int $id
 * @property int $firm_id
 * @property int $plan_id
 * @property string $status
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @method static Builder<static>|FirmPlan newModelQuery()
 * @method static Builder<static>|FirmPlan newQuery()
 * @method static Builder<static>|FirmPlan query()
 * @method static Builder<static>|FirmPlan whereCreatedAt($value)
 * @method static Builder<static>|FirmPlan whereFirmId($value)
 * @method static Builder<static>|FirmPlan whereId($value)
 * @method static Builder<static>|FirmPlan wherePlanId($value)
 * @method static Builder<static>|FirmPlan whereStatus($value)
 * @method static Builder<static>|FirmPlan whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class FirmPlan extends Model
{
    protected  $table='firm_plans';
    protected $fillable=[
      'firm_id',
      'plan_id',
      'status'
    ];

}
