<?php

namespace App\Models;

use App\Traits\HasStatus;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;

/**
 * @property int $id
 * @property int $firm_id
 * @property int $user_id
 * @property string $session_id
 * @property string $date
 * @property int $day_plus
 * @property int $profit
 * @property string|null $last_activity_time
 * @property int|null $session_duration
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read mixed $status
 * @method static Builder<static>|Firmlog newModelQuery()
 * @method static Builder<static>|Firmlog newQuery()
 * @method static Builder<static>|Firmlog query()
 * @method static Builder<static>|Firmlog whereCreatedAt($value)
 * @method static Builder<static>|Firmlog whereDate($value)
 * @method static Builder<static>|Firmlog whereDayPlus($value)
 * @method static Builder<static>|Firmlog whereFirmId($value)
 * @method static Builder<static>|Firmlog whereId($value)
 * @method static Builder<static>|Firmlog whereLastActivityTime($value)
 * @method static Builder<static>|Firmlog whereProfit($value)
 * @method static Builder<static>|Firmlog whereSessionDuration($value)
 * @method static Builder<static>|Firmlog whereSessionId($value)
 * @method static Builder<static>|Firmlog whereUpdatedAt($value)
 * @method static Builder<static>|Firmlog whereUserId($value)
 * @mixin \Eloquent
 */
class Firmlog extends Model
{
    use  HasStatus;
    protected $fillable = [
        'user_id',
        'firm_id',
        'session_id',
        'date',
        'day_plus',
        'last_activity_time',
        'profit',
    ];
    protected $table = 'firmlogs';

}
