<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;


/**
 * @method static leftJoin(string $string, string $string1, string $string2, string $string3)
 * @method static select()
 * @method static whereHas(string $string, \Closure $param)
 */
class Nomenclature extends Model
{
    protected $table = 'product_names';

    public function images(): HasMany
    {
        return $this->hasMany(ProductNameImage::class, 'product_name_id', 'id');
    }

    public function type(): BelongsTo
    {
        return $this->belongsTo(ProductNameType::class, 'product_name_type_id');
    }

    public function manufacturer(): BelongsTo
    {
        return $this->belongsTo(Manufacturer::class, 'manufacture_id');
    }
    public function categories(): BelongsToMany
    {
        return $this->belongsToMany(CategoryProductName::class, 'product_name_category_names','product_names_id','category_product_names_id');
    }
}
