<?php

namespace App\Models;

use App\Traits\HasOrderStatus;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Carbon;


/**
 * @property int $id
 * @property int $id_firm_sender
 * @property int $id_firm_income
 * @property int $overhead_id
 * @property string $number
 * @property int $status
 * @property int|null $stock_status
 * @property int $approved
 * @property string|null $comment
 * @property int|null $discount
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read Collection<int, OrderItem> $items
 * @property-read int|null $items_count
 * @property-read Overhead|null $overhead
 * @method static Builder<static>|Order newModelQuery()
 * @method static Builder<static>|Order newQuery()
 * @method static Builder<static>|Order query()
 * @method static Builder<static>|Order whereApproved($value)
 * @method static Builder<static>|Order whereComment($value)
 * @method static Builder<static>|Order whereCreatedAt($value)
 * @method static Builder<static>|Order whereDiscount($value)
 * @method static Builder<static>|Order whereId($value)
 * @method static Builder<static>|Order whereIdFirmIncome($value)
 * @method static Builder<static>|Order whereIdFirmSender($value)
 * @method static Builder<static>|Order whereNumber($value)
 * @method static Builder<static>|Order whereOverheadId($value)
 * @method static Builder<static>|Order whereStatus($value)
 * @method static Builder<static>|Order whereStockStatus($value)
 * @method static Builder<static>|Order whereUpdatedAt($value)
 * @method static selectRaw(string $string)
 */
class Order extends Model
{
    use HasOrderStatus;

    protected $table = 'orders';
    protected $fillable = [
        'overhead_id',
        'id_firm_sender',
        'id_firm_income',
        'number',
        'comment',
        'discount'

    ];

    public function items(): HasMany
    {
        return $this->hasMany(OrderItem::class, 'order_id');
    }

    public function supplier(): BelongsTo
    {
        return $this->belongsTo(Firm::class, 'id_firm_sender');
    }

    public function overhead(): BelongsTo
    {
        return $this->belongsTo(Overhead::class);
    }


}
