<?php

namespace App\Models;

use App\Traits\HasStatus;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Carbon;

/**
 * @property int $id
 * @property int $order_id
 * @property int $product_id
 * @property string $title
 * @property string $quantity
 * @property string $price
 * @property string|null $discount
 * @property string|null $date_expire
 * @property string|null $manufacture
 * @property int $status
 * @property int $stock_status
 * @property string|null $comment
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read Order $order
 * @method static Builder<static>|OrderItem newModelQuery()
 * @method static Builder<static>|OrderItem newQuery()
 * @method static Builder<static>|OrderItem query()
 * @method static Builder<static>|OrderItem whereComment($value)
 * @method static Builder<static>|OrderItem whereCreatedAt($value)
 * @method static Builder<static>|OrderItem whereDateExpire($value)
 * @method static Builder<static>|OrderItem whereDiscount($value)
 * @method static Builder<static>|OrderItem whereId($value)
 * @method static Builder<static>|OrderItem whereManufacture($value)
 * @method static Builder<static>|OrderItem whereOrderId($value)
 * @method static Builder<static>|OrderItem wherePrice($value)
 * @method static Builder<static>|OrderItem whereProductId($value)
 * @method static Builder<static>|OrderItem whereQuantity($value)
 * @method static Builder<static>|OrderItem whereStatus($value)
 * @method static Builder<static>|OrderItem whereStockStatus($value)
 * @method static Builder<static>|OrderItem whereTitle($value)
 * @method static Builder<static>|OrderItem whereUpdatedAt($value)
 */
class OrderItem extends Model
{
    use  HasStatus;
    protected $table = 'orderlists';
    protected $fillable = [
        'order_id', 'product_id',
        'title',
        'quantity',
        'price',
        'discount',
        'date_expire',
        'manufacture',
        'comment',
    ];
    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class);
    }

    public function product(): BelongsTo
    {
        return $this->belongsTo(Drugstore::class, 'product_id');
    }
}
