<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Carbon;

/**
 * @property int $id
 * @property int $firm_id
 * @property int $discount_id
 * @property int $status
 * @property string|null $date_overhead
 * @property string|null $currency
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read Discount|null $discount
 * @property-read Firm|null $firm
 * @property-read Collection<int, Partner> $partners
 * @property-read int|null $partners_count
 * @method static Builder<static>|Overhead newModelQuery()
 * @method static Builder<static>|Overhead newQuery()
 * @method static Builder<static>|Overhead query()
 * @method static Builder<static>|Overhead whereCreatedAt($value)
 * @method static Builder<static>|Overhead whereCurrency($value)
 * @method static Builder<static>|Overhead whereDateOverhead($value)
 * @method static Builder<static>|Overhead whereDiscountId($value)
 * @method static Builder<static>|Overhead whereFirmId($value)
 * @method static Builder<static>|Overhead whereId($value)
 * @method static Builder<static>|Overhead whereStatus($value)
 * @method static Builder<static>|Overhead whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class Overhead extends Model
{
    protected $table='overheads';

    public function firm():BelongsTo
    {
        return $this->belongsTo(Firm::class);
    }
    public function  discount(): BelongsTo
    {
        return $this->belongsTo(Discount::class);
    }


}
