<?php

namespace App\Models;

use App\Traits\HasStatus;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Carbon;

/**
 * @property int $id
 * @property int $firm1
 * @property int $firm2
 * @property int $status
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read Firm|null $firm
 * @method static Builder<static>|Partner newModelQuery()
 * @method static Builder<static>|Partner newQuery()
 * @method static Builder<static>|Partner query()
 * @method static Builder<static>|Partner whereCreatedAt($value)
 * @method static Builder<static>|Partner whereFirm1($value)
 * @method static Builder<static>|Partner whereFirm2($value)
 * @method static Builder<static>|Partner whereId($value)
 * @method static Builder<static>|Partner whereStatus($value)
 * @method static Builder<static>|Partner whereUpdatedAt($value)
 */

class Partner extends Model
{
    use HasStatus;
    protected $table="partnergroups";

    public  function firm(): BelongsTo
    {
        return $this->belongsTo(Firm::class,'firm2');
    }
    public function firms():BelongsToMany
    {
        return $this->belongsToMany(Firm::class, 'partnergroups', 'firm1','firm2');
    }

}
