<?php

namespace App\Models;

use App\Traits\HasStatus;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;

/**
 * @property int $id
 * @property int $payment_method_id
 * @property string $image
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read mixed $status
 * @method static Builder<static>|PaymentImage newModelQuery()
 * @method static Builder<static>|PaymentImage newQuery()
 * @method static Builder<static>|PaymentImage query()
 * @method static Builder<static>|PaymentImage whereCreatedAt($value)
 * @method static Builder<static>|PaymentImage whereId($value)
 * @method static Builder<static>|PaymentImage whereImage($value)
 * @method static Builder<static>|PaymentImage wherePaymentMethodId($value)
 * @method static Builder<static>|PaymentImage whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class PaymentImage extends Model
{
    use  HasStatus;
    protected $table="payment_method_images";

}
