<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * @method static create($data)
 * @method static selectRaw(string $string)
 * @method static where(string $string, $supplier_id)
 */
class Review extends Model
{
    protected $fillable = [
        'supplier_id',
        'firm_id',
        'reason_list_id',
        'product_name',
        'reason_list_id',
        'comment'
    ];




    public function firm(): BelongsTo
    {
        return $this->belongsTo(Firm::class, 'firm_id', 'id');
    }
    public function reasonList():BelongsTo
    {
        return  $this->belongsTo(ReasonList::class, 'reason_list_id','id');
    }


}
