<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;

/**
 * @property int $id
 * @property string|null $email
 * @property string|null $phone
 * @property string|null $code
 * @property string|null $remember_token
 * @property int|null $status
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @method static Builder<static>|Take newModelQuery()
 * @method static Builder<static>|Take newQuery()
 * @method static Builder<static>|Take query()
 * @method static Builder<static>|Take whereCode($value)
 * @method static Builder<static>|Take whereCreatedAt($value)
 * @method static Builder<static>|Take whereEmail($value)
 * @method static Builder<static>|Take whereId($value)
 * @method static Builder<static>|Take wherePhone($value)
 * @method static Builder<static>|Take whereRememberToken($value)
 * @method static Builder<static>|Take whereStatus($value)
 * @method static Builder<static>|Take whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class Take extends Model
{
    protected $table = 'takes';
    protected $fillable = ['email', 'phone', 'code',];
}
