<?php

namespace App\Providers;

use App\Interfaces\Cities\CityInterface;
use App\Interfaces\Day_plusInterface;
use App\Interfaces\FilterMyPartnerInterface;
use App\Interfaces\FirmCityInterface;
use App\Interfaces\FirmInterface;
use App\Interfaces\FirmPlans\FirmPlanInterface;
use App\Interfaces\Nomenclatures\NomenclatureInterface;
use App\Interfaces\Notifications\NotificationInterface;
use App\Interfaces\OrderInterfaces\OrderInterface;
use App\Interfaces\Overhead\OverheadInterface;
use App\Interfaces\PartnerInterface;
use App\Interfaces\PaymentRepositoryInterface;
use App\Interfaces\Plans\PlanInterface;
use App\Interfaces\Products\ProductInterface;
use App\Interfaces\ProductTypeInterface;
use App\Interfaces\Reviews\ReviewInterface;
use App\Interfaces\Tutorials\TutorialInterface;
use App\Interfaces\UserInterface;
use App\Interfaces\VerificationServiceInterface;
use App\Repositories\Cities\CityRepository;
use App\Repositories\Day_plusRepository;
use App\Repositories\FirmPlans\FirmPlanRepository;
use App\Repositories\FirmRepositories\FirmCityRepositories;
use App\Repositories\FirmRepository;
use App\Repositories\Nomenclatures\NomenclatureRepository;
use App\Repositories\Notifications\NotificationRepository;
use App\Repositories\OrderRepositories\OrderRepository;
use App\Repositories\Overhead\OverheadRepository;
use App\Repositories\PartnerRepository;
use App\Repositories\PaymentRepository;
use App\Repositories\Plans\PlanRepository;
use App\Repositories\Products\ProductRepository;
use App\Repositories\Reviews\ReviewRepository;
use App\Repositories\SearchRepositories\FilterMyPartnersRepository;
use App\Repositories\SearchRepositories\ProductTypeRepository;
use App\Repositories\Tutorials\TutorialRepository;
use App\Services\Search\FilterMyPartnersService;
use App\Services\SmsVerificationService;
use App\Services\UserService;
use Carbon\CarbonInterval;
use Elastic\Elasticsearch\Client;
use Elastic\Elasticsearch\ClientBuilder;
use Illuminate\Support\ServiceProvider;
use Laravel\Passport\Passport;
use Matchish\ScoutElasticSearch\Engine;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->singleton('elasticsearch', function () {
            $host = sprintf(
                '%s://%s:%s@%s:%d',
                env('ELASTICSEARCH_SCHEME', 'http'),
                env('ELASTICSEARCH_USERNAME'),
                env('ELASTICSEARCH_PASSWORD'),
                env('ELASTICSEARCH_HOST', 'localhost'),
                env('ELASTICSEARCH_PORT', 9200)
            );

            return \Elastic\Elasticsearch\ClientBuilder::create()
                ->setHosts([$host])
                ->build();
        });
        $this->app->bind(
            FilterMyPartnerInterface::class,
            FilterMyPartnersRepository::class

        );
        $this->app->bind(
            FirmCityInterface::class,
            FirmCityRepositories::class
        );
        $this->app->bind(
            VerificationServiceInterface::class,
            SmsVerificationService::class
        );
        $this->app->bind(
            FirmInterface::class,
            FirmRepository::class
        );

        $this->app->bind(
            UserInterface::class,
            UserService::class
        );
        $this->app->bind(
            PaymentRepositoryInterface::class,
            PaymentRepository::class
        );
        $this->app->bind(
            PartnerInterface::class,
            PartnerRepository::class
        );
        $this->app->bind(
            Day_plusInterface::class,
            Day_plusRepository::class
        );
        $this->app->bind(
            ProductTypeInterface::class,
            ProductTypeRepository::class
        );
        $this->app->bind(
            OrderInterface::class,
            OrderRepository::class
        );
        $this->app->bind(
            TutorialInterface::class,
            TutorialRepository::class
        );
        $this->app->bind(
            NotificationInterface::class,
            NotificationRepository::class
        );
        $this->app->bind(
            PlanInterface::class,
            PlanRepository::class
        );
        $this->app->bind(
            FirmPlanInterface::class,
            FirmPlanRepository::class
        );
        $this->app->bind(
            CityInterface::class,
            CityRepository::class
        );
        $this->app->bind(
            ReviewInterface::class,
            ReviewRepository::class
        );
        $this->app->bind(
            ProductInterface::class,
            ProductRepository::class
        );
        $this->app->bind(
            OverheadInterface::class,
            OverheadRepository::class
        );
        $this->app->bind(
            NomenclatureInterface::class,
            NomenclatureRepository::class,
        );
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Passport::enablePasswordGrant();
        Passport::tokensExpireIn(CarbonInterval::days(15));
        Passport::refreshTokensExpireIn(CarbonInterval::days(30));
    }

    private function registerSearchClient(): void
    {
        $this->app->singleton(Client::class, function ($app) {
            return ClientBuilder::create()
                ->setHosts($app['config']->get('services.search.hosts'))
                ->build();
        });
    }
}
