<?php

namespace App\Repositories\Cities;

use App\Interfaces\Cities\CityInterface;
use App\Models\City;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Monolog\Level;

class CityRepository implements CityInterface
{

    public function getCity(?string $title = null): Collection
    {
        return City::select('id', 'title')
            ->where('status', 1)->get();
    }

    public function getCheckedCityIds($firmId): Collection
    {
        $cacheKey = "firm_{$firmId}_cities_status";
        $cachedStatus = Cache::get($cacheKey, []);
        $unCheckedIds = collect($cachedStatus)
            ->filter(fn($value) => $value === '0' || $value === false)
            ->keys()
            ->toArray();

        $query = City::query();
        if (!empty($unCheckedIds)) {
            $query->whereNotIn('id', $unCheckedIds);

        }
        return $query->pluck('id');
    }

    public function getAllCityIdsWithChecked($firmId): array
    {
        $cacheKey = "firm_{$firmId}_cities_status";
        return Cache::get($cacheKey, []);
    }
}
