<?php

namespace App\Repositories;

use App\Interfaces\Day_plusInterface;
use App\Models\Firm;
use App\Models\Firmlog;

class Day_plusRepository implements Day_plusInterface{
    public function day_plus($userId,$firmId){
         $firm = Firm::whereHas('userFirms', function ($query) use ($userId) {
            $query->where('user_id', $userId)
                ->whereIn('status', [1, 2]);
        })
            ->where('id', $firmId)
            ->first();
        return $firm;
    }
    public function firmLog($firmId, $userId, $today)
    {
        $firmlog = Firmlog::where('user_id', $userId)
            ->where('firm_id', $firmId)
            ->where('date', $today)
            ->first();

        return $firmlog;
    }
}