<?php

namespace App\Repositories\FirmPlans;

use App\Interfaces\FirmPlans\FirmPlanInterface;
use App\Models\FirmPlan;


class FirmPlanRepository implements FirmPlanInterface
{
    public function getFirmPlan($firmId)
    {
        return FirmPlan::select('plans.id', 'plans.name', 'firm_plans.status')
            ->join('plans', 'plans.id', '=', 'firm_plans.plan_id')
            ->where('firm_plans.firm_id', $firmId)
            ->whereIn('firm_plans.status', ['not_paid','active'])
            ->first();
    }

    public function getFirmPlanById($firmId, $planId)
    {
        return FirmPlan::where('firm_id', $firmId)
            ->where('plan_id', $planId)
            ->first();
    }

    public function updateFirmPlan($firmId)
    {
        return FirmPlan::where('firm_id', $firmId)->update(['status' => 'inactive']);
    }
    public function updateFirmPlanById($firmId, $planId,$status)
    {
        return FirmPlan::where('firm_id', $firmId)->where('plan_id', $planId)->update(['status' => $status]);
    }

    public function assignPlanToFirm($firmId, $planId):string
    {
         FirmPlan::create([
            'firm_id' => $firmId,
            'plan_id' => $planId,
            'status'  => 'not_paid'

        ]);

        return 'Created new plan' ;
    }
}
