<?php

namespace App\Repositories;

use App\Interfaces\FirmInterface;
use App\Models\Category;
use App\Models\Firm;
use App\Models\Firmlog;
use Illuminate\Support\Facades\Auth;

class FirmRepository implements FirmInterface
{
    public function createFirm($data)
    {
        $firm = Firm::create($data);
        return $firm;
    }

    public function categoriesFirm()
    {
        $categorieFirm = Category::where('status', 1)->get();
        return $categorieFirm;
    }
    public function getFirmByID($firmId)
    {
        return Firm::where('id', $firmId)
             ->whereIn('status', [1, 2])
             ->first();
    }
    public function firmLog($firmId ,$userId, $today)
    {
         $firmlog = Firmlog::where('user_id', $userId)
            ->where('firm_id', $firmId)
            ->where('date', $today)
            ->first();

         return $firmlog ;
    }

    public function firmProfile($firmId)
    {
        return Firm::select('title','phone')->where('id',$firmId)->first();
    }
    public function  workingData($firmId)
    {
        return Firm::select(
            'img',
            'address',
            'title',
            'phone',
            'phone1 as additional_phone',
            'latitude',
            'longtitude as longitude'
        )->where('id', $firmId)->first();
    }

    public function updateWorkingData($data, $firmId)
    {
        return  Firm::where('id',$firmId)->update($data);
    }

    public function updateGeo($data, $firmId)
    {
        return Firm::where('id', $firmId)->update($data);
    }
}
