<?php

namespace App\Repositories\Products;

use App\Interfaces\Products\ProductInterface;
use App\Models\Drugstore;
use Illuminate\Database\Eloquent\Collection;

class ProductRepository implements ProductInterface
{
    public function getProductName($product_id)
    {
            return Drugstore::where('id',$product_id)->value('title');
    }

    public function getProductById($id,$firmId): ?Drugstore
    {
        return Drugstore::with('overhead','overhead.firm')
            ->whereHas('overhead',function ($q) use ($firmId){
                $q->whereIn('firm_id', function ($sub) use ($firmId){
                    $sub->select('firm2')
                        ->from('partnergroups')
                        ->where('firm1', $firmId);
                });
            })
            ->where('id',$id)
            ->first();
    }

}
