<?php

namespace App\Repositories\Reviews;

use App\Interfaces\Reviews\ReviewInterface;
use App\Models\ReasonList;
use App\Models\Review;
use Illuminate\Database\Eloquent\Collection;

class ReviewRepository implements ReviewInterface
{
    public function get()
    {
        return ReasonList::select('id', 'name', 'type')->get();
    }

    public function create($data)
    {
        return Review::create($data);
    }

    public function getReviews($supplier_id): Collection
    {
        return Review::with(['firm', 'reasonList'])
            ->where('supplier_id', $supplier_id)
            ->where('status', 1)
            ->orderBy('created_at', 'desc')
            ->get();
    }

    public function getRating($supplier_id)
    {
        return Review::where('supplier_id', $supplier_id)
            ->join('reason_lists', 'reason_lists.id', '=', 'reviews.reason_list_id')
            ->selectRaw('
               COUNT(*) as total_count,
               SUM(CASE WHEN reason_lists.type = "like" THEN 1 ELSE 0 END) as positive_count,
               SUM(CASE WHEN reason_lists.type = "dislike" THEN 1 ELSE 0 END) as negative_count
               ')
            ->where('reviews.status', 1)
            ->first();
    }
}
