<?php

namespace App\Rules;

use Closure;

use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Support\Facades\DB;

readonly class ValidateFirmGroup implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param \Closure(string, ?string=): \Illuminate\Translation\PotentiallyTranslatedString $fail
     */
    public function __construct(private int $firmId)
    {
    }

    public function validate(string $attribute, mixed $value, Closure $fail): void
    {

        $exists= DB::table('partnergroups')
            ->where('firm2', $value)
            ->where('firm1', $this->firmId)
            ->where('status', 1)
            ->exists();
        if (!$exists){
            $fail('The selected partner id is invalid or inactive.');
        }
    }
}
