<?php

namespace App\Services;

use App\Interfaces\UserInterface;
use App\Interfaces\VerificationServiceInterface;
use Illuminate\Support\Facades\Auth;
use Laravel\Passport\Http\Controllers\AccessTokenController;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class AuthService
{
    public function __construct(
        protected VerificationServiceInterface $verification_service_interface,
        protected UserInterface $user_interface,
        protected FormatPhoneService $formatPhoneService
    ) {}

    /**
     * @OA\POST(
     *   path="/api/phonenumber",
     *     tags={"Auth"},
     *      @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                      @OA\Property(
     *                      property="country_code",
     *                      type="string" ,
     *                      example="+992"
     *                      ),
     *                      @OA\Property(
     *                          property="phone",
     *                          type="int",
     *                          example=921231212
     *                      ),
     *
     *
     * ),
     * ),
     *   ),
     *   @OA\Response(response="200", description="Success")
     * )
     */

    public function registerOrLogin($request)
    {
        $phone = $this->formatPhoneService->formatPhone($request->country_code, $request->phone);
        return  $this->verification_service_interface->createVerificationCode($phone);
    }
    /**
     * @OA\POST(
     *      path="/api/verifysms",
     *      tags={"Auth"},
     *    @OA\RequestBody(
     *         @OA\MediaType(
     *             mediaType="application/json",
     *             @OA\Schema(
     *                     @OA\Property(
     *                     property="country_code",
     *                     type="string",
     *                     example="+992"
     *                 ),
     *                 @OA\Property(
     *                     property="phone",
     *                     type="int",
     *                      example=921231212
     *                 ),
     *                 @OA\Property(
     *                     property="code",
     *                     type="int",
     *                     example=123456
     *                 ),
     *             ),
     *         ),
     * ),
     *  @OA\Response(response="200", description="Success")
     *
     * )
     */
    public function verifysms($request)
    {
        $phone = $this->formatPhoneService->formatPhone($request->country_code, $request->phone);
        $code = $request->code;
        $name = $request->name ?? "User";
        $data = $this->verification_service_interface->verificationCode($code, $phone);


        if (!$data["status"]) {
            return $data;
        }

        $user = $this->user_interface->createUser($name, $phone, $code);
        $psrRequest = app(ServerRequestInterface::class)->withParsedBody([
            'grant_type' => 'password',
            'client_id' => config('services.passport.client_id'),
            'client_secret' => config('services.passport.client_secret'),
            'username' => $phone,
            'password' => $code,
            'scope' => '*',
        ]);
        $psrResponse = app(ResponseInterface::class);

        $tokenResponse = app(AccessTokenController::class)->issueToken($psrRequest, $psrResponse);
        $data = json_decode($tokenResponse->getContent(), true);
        return [
            "access_token" => $data['access_token'],
            "expires_in" => $data['expires_in'],
            "refresh_token" => $data['refresh_token'],
            "status" => true
        ];
    }

    /**
     * @OA\Get(
     *      path="/api/logout",
     *      tags={"Auth"},
     *       security={{"bearerAuth":{}}},
     *      summary="logout User",
     *      description="logout User",
     *      @OA\Response(
     *          response=200,
     *          description="Successful operation",
     *          @OA\MediaType(
     *           mediaType="application/json",
     *      )
     *      ),
     *  )
     */

    public function logout()
    {
        $user = Auth::user()->token();
        $user->revoke();
        return 'logged out';
    }
}
