<?php

namespace App\Services;

use App\Interfaces\Day_plusInterface;
use App\Models\Firm;
use App\Models\Firmlog;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;

class Day_plusService
{

    public function __construct(
        protected Day_plusInterface $day_plus_interface
    ) {}
    /**
     * @OA\Get(
     *      path="/api/day_plus",
     *      tags={"Firm"},
     *       security={{"bearerAuth":{}}},
     *      summary="Day plus",
     *      description="Day plus",
     *       @OA\Parameter(
     *         name="firm_id",
     *         in="header",
     *         required=true,
     *         @OA\Schema(
     *             type="integer",
     *             example=1
     *         )
     *     ),
     *      @OA\Response(
     *          response=200,
     *          description="Successful operation",
     *          @OA\MediaType(
     *           mediaType="application/json",
     *      )
     *      ),
     *  )
     */
    public function day_plus($request)
    {


        $userId = Auth::id();
        // $userId=20;
        $firmId = $request->header('firm_id');
        $today = now()->format('Y-m-d');
        $firm = $this->day_plus_interface->day_plus($userId, $firmId);
        if (!$firm) {
            return $array = [
                'message' => 'Фирма не найдена',
            ];
        }
        if ($firm->left_days <= 0) {
            return $array = [
                'message' => 'Ваш баланс исчерпан. Для продолжения работы пополните счёт. У нас есть пошаговая инструкция со скриншотами — воспользуйтесь ею, если что-то непонятно запросите звонок или напишите нам удобным вам способом.',
            ];
        }

        $firmlog = $this->day_plus_interface->firmLog($firmId, $userId, $today);


        if (!$firmlog) {
            $data = [
                'user_id' => $userId,
                'firm_id' => $firmId,
                'session_id' => $request->header('User-Agent'),
                'date' => $today,
                'day_plus' => 0,
                'last_activity_time' => now(),
                'profit' => 1,
            ];
            $firm->decrement('left_days');
            $today_key = "cache_cleared_{$firmId}_" . date('Y-m-d');
            if (!Cache::has($today_key)) {
                Cache::forget("discounts_to_{$firmId}");
                Cache::forget("firm_overheads_{$firmId}");
                Cache::put($today_key, true, now()->addDay());
            }

            Firmlog::create($data);
            $firm = Firm::where('id', $firmId)->first();
            activity('day_plus')
                ->performedOn($firm)
                ->withProperties([
                    'title' => "Дополнительно снято 1 день",
                    "body" => "Cнято 1 день. Осталось: " . $firm->left_days,
                ])
                ->log("Вход выполнен");
        }
        return $array = [
            'massage' => 'Вход выполнен'
        ];
    }
}
