<?php

namespace App\Services\Drugstore;

use App\Interfaces\Products\ProductInterface;
use App\Models\Drugstore;
use App\Repositories\Products\ProductRepository;

class DiscountService
{
    public function __construct
    (
        protected ProductInterface $product
    )
    {
    }

    public function discount(Drugstore $product): float
    {

        $discount = $product->discount ?? 0;
        if (
            $product->overhead &&
            $product->overhead->discount &&
            $product->overhead->discount->status == 1
        ) {
            $overheadDiscount = $product->overhead->discount->discount ?? 0;
            if ($overheadDiscount > $discount) {
                $discount = $overheadDiscount;
            }
        }
        return $discount;
    }

}
