<?php

namespace App\Services\Drugstore;

use App\Interfaces\OrderInterfaces\OrderInterface;
use App\Interfaces\Products\ProductInterface;
use App\Services\Reviews\ReviewStatisticsService;

class DrugstoreService
{
    public function __construct(
        protected ProductInterface        $product,
        protected DiscountService         $discountService,
        protected ReviewStatisticsService $reviewStatisticsService,
        protected OrderInterface          $orderInterface,
    )
    {
    }

    public function getProductById($request): array
    {
        $firmId = $request->header('firm_id');
        $supplier_id = $request->supplier_id;
        $id = $request->id;

        $data = $this->product->getProductById($id, $firmId);
        $discount = $this->discountService->discount($data);
        $reviews = $this->reviewStatisticsService->getRatingSummary($supplier_id);
        return [
            'title' => $data->title,
            'img' => $data->img ?? 'products/1.png',
            'price' => $data->price,
            'discount' => $discount,
            'price_with_discount' => number_format(($data->price) * (1 - $discount / 100), 2),
            'manufacture' => $data->manufacture,
            'date_expire' => $data->date_expire,
            'date_price_list' => $data->overhead->date_overhead ?? null,
            'supplier_id' => $supplier_id,
            'firm_title' => $data->overhead->firm->title,
            'quantity' => (int)$this->orderInterface->getProductQuantityById($id, $supplier_id) ?? 0,
            'reviews' => $reviews,
        ];
    }

}
